<?php
session_start();

// 96 Configuracin de usuarios (admin)
$users = [
    ["username" => "admin", "password" => "12345"] // <-- cmbialo por tus credenciales
];

// Ruta del archivo con los nombres permitidos
$allowedFile = __DIR__ . "/allowed.json";

// Si no existe el JSON, crearlo vaco
if (!file_exists($allowedFile)) {
    file_put_contents($allowedFile, json_encode(["names" => []], JSON_PRETTY_PRINT));
}

// Leer accin desde la URL
$action = $_GET["action"] ?? "";

// --- LOGIN ---
if ($action === "login") {
    $data = json_decode(file_get_contents("php://input"), true);
    $username = $data["username"] ?? "";
    $password = $data["password"] ?? "";

    global $users;
    foreach ($users as $u) {
        if ($u["username"] === $username && $u["password"] === $password) {
            $_SESSION["user"] = $username;
            echo json_encode(["success" => true, "message" => "Login exitoso"]);
            exit;
        }
    }
    echo json_encode(["success" => false, "message" => "Credenciales invlidas"]);
    exit;
}

// --- LOGOUT ---
if ($action === "logout") {
    session_destroy();
    echo json_encode(["success" => true, "message" => "Sesin cerrada"]);
    exit;
}

// --- CHECK SESSION ---
if ($action === "checkSession") {
    echo json_encode([
        "loggedIn" => isset($_SESSION["user"])
    ]);
    exit;
}

// --- GET NAMES ---
if ($action === "getNames") {
    if (!isset($_SESSION["user"])) {
        echo json_encode(["success" => false, "message" => "No autorizado"]);
        exit;
    }
    $allowed = json_decode(file_get_contents($allowedFile), true);
    echo json_encode(["success" => true, "names" => $allowed["names"] ?? []]);
    exit;
}

// --- ADD NAME ---
if ($action === "addName") {
    if (!isset($_SESSION["user"])) {
        echo json_encode(["success" => false, "message" => "No autorizado"]);
        exit;
    }
    $data = json_decode(file_get_contents("php://input"), true);
    $name = trim($data["name"] ?? "");

    if ($name === "") {
        echo json_encode(["success" => false, "message" => "Nombre invlido"]);
        exit;
    }

    $allowed = json_decode(file_get_contents($allowedFile), true);
    if (!in_array($name, $allowed["names"])) {
        $allowed["names"][] = $name;
        file_put_contents($allowedFile, json_encode($allowed, JSON_PRETTY_PRINT));
    }

    echo json_encode(["success" => true, "message" => "Nombre agregado"]);
    exit;
}

// --- REMOVE NAME ---
if ($action === "removeName") {
    if (!isset($_SESSION["user"])) {
        echo json_encode(["success" => false, "message" => "No autorizado"]);
        exit;
    }
    $data = json_decode(file_get_contents("php://input"), true);
    $name = trim($data["name"] ?? "");

    $allowed = json_decode(file_get_contents($allowedFile), true);
    $allowed["names"] = array_values(array_filter($allowed["names"], fn($n) => $n !== $name));
    file_put_contents($allowedFile, json_encode($allowed, JSON_PRETTY_PRINT));

    echo json_encode(["success" => true, "message" => "Nombre eliminado"]);
    exit;
}

// --- DEFAULT ---
echo json_encode(["success" => false, "message" => "Accin invlida"]);
exit;