<?php
// ============================
// Validación con allowed.json
// ============================
$allowedFile = __DIR__ . "/allowed.json";
$allowed = [];
if (file_exists($allowedFile)) {
    $json = json_decode(file_get_contents($allowedFile), true);
    $allowed = $json["names"] ?? []; // <-- Ahora lee de "names"
}

$nombre = $_GET["nombre"] ?? "";
if (!$nombre || !in_array($nombre, $allowed)) {
    echo "<div style='text-align:center; margin-top:20%; font-family:Arial'>
        <h1 style='color:red'>🔒🔑 Solicítalo en TikTok</h1>
        <a href='https://www.tiktok.com/@jimeyker' target='_blank' rel='noopener noreferrer'>
            <button style=\"
                background: linear-gradient(135deg, #25F4EE, #FE2C55);
                color: white;
                font-size: 16px;
                font-weight: bold;
                padding: 12px 24px;
                border: none;
                border-radius: 30px;
                cursor: pointer;
                transition: transform 0.2s ease, box-shadow 0.2s ease;
            \"
            onmouseover=\"this.style.transform='translateY(-3px) scale(1.05)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.2)'\"
            onmouseout=\"this.style.transform='none'; this.style.boxShadow='none'\"
            >
                Ir a @jimeyker
            </button>
        </a>
    </div>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Lluvia de Te Amo</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      overflow: hidden;
      background-color: #111;
      touch-action: manipulation;
      font-family: 'Arial', sans-serif;
      cursor: pointer;
      height: 100vh;
      width: 100vw;
    }

    .love-word {
      position: absolute;
      font-weight: bold;
      user-select: none;
      pointer-events: none;
      animation: fall linear forwards;
      opacity: 0.9;
      text-shadow: 0 0 8px rgba(255, 0, 0, 0.7);
    }

    @keyframes fall {
      0% {
        transform: translateX(0) translateY(0);
        opacity: 1;
      }
      50% {
        transform: translateX(20px) translateY(50vh) rotate(10deg);
        opacity: 0.9;
      }
      100% {
        transform: translateX(-20px) translateY(100vh) rotate(-10deg);
        opacity: 0;
      }
    }

    .explosion {
      position: absolute;
      font-size: 20px;
      user-select: none;
      pointer-events: none;
      animation: explode 1.8s ease-out forwards;
      opacity: 0;
      font-weight: bold;
      text-shadow: 0 0 5px rgba(255, 255, 255, 0.7);
    }

    @keyframes explode {
      0% {
        transform: translate(0, 0) scale(1);
        opacity: 1;
      }
      100% {
        transform: translate(var(--tx), var(--ty)) scale(0);
        opacity: 0;
      }
    }

    /* Ocultar controles de audio */
    #bg-music {
      position: absolute;
      opacity: 0;
      width: 1px;
      height: 1px;
    }
  </style>
</head>
<body>
  <!-- Música de fondo -->
  <audio id="bg-music" loop autoplay muted>
    <source src="https://files.catbox.moe/jfhdug.mp3" type="audio/mpeg">
    Tu navegador no soporta el elemento de audio.
  </audio>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const body = document.body;
      const audio = document.getElementById('bg-music');

      // Configurar audio
      audio.volume = 0.4;

      // Colores rojos para las palabras que caen
      const redColors = [
        '#ff0000','#ff6b6b','#ff9999','#cc0000',
        '#ff3333','#ff8080','#e60000','#ff4d4d'
      ];

      // Colores pastel para las explosiones
      const explosionColors = [
        '#FFB6C1','#FFD700','#98FB98','#ADD8E6','#E6E6FA',
        '#FFA07A','#87CEFA','#FFDEAD','#F0E68C','#DDA0DD'
      ];

      // Nombre desde PHP
      const nombre = "<?php echo htmlspecialchars($nombre); ?>";

      // Crear palabras que caen
      function createFallingWord() {
        const words = [nombre, 'Te amo', '❤️'];
        const word = document.createElement('div');
        word.className = 'love-word';
        word.textContent = words[Math.floor(Math.random() * words.length)];
        word.style.left = Math.random() * 100 + 'vw';
        word.style.animationDuration = (Math.random() * 3 + 2) + 's';
        word.style.color = redColors[Math.floor(Math.random() * redColors.length)];
        word.style.fontSize = (Math.random() * 15 + 20) + 'px';
        word.style.opacity = Math.random() * 0.7 + 0.3;

        body.appendChild(word);
        setTimeout(() => word.remove(), parseFloat(word.style.animationDuration) * 1000);
      }

      // Lluvia inicial
      for (let i = 0; i < 50; i++) {
        setTimeout(createFallingWord, Math.random() * 2000);
      }

      // Lluvia continua
      setInterval(createFallingWord, 200);

      // Explosión al hacer click/touch
      function createExplosion(e) {
        const x = e.clientX || (e.touches && e.touches[0].clientX);
        const y = e.clientY || (e.touches && e.touches[0].clientY);
        if (x === undefined || y === undefined) return;

        for (let i = 0; i < 40; i++) {
          const particle = document.createElement('div');
          particle.className = 'explosion';
          particle.textContent = Math.random() > 0.3 ? 'Te Amo' : '❤️';
          particle.style.left = x + 'px';
          particle.style.top = y + 'px';
          particle.style.color = explosionColors[Math.floor(Math.random() * explosionColors.length)];

          const angle = Math.random() * Math.PI * 2;
          const distance = Math.random() * 150 + 80;
          const tx = Math.cos(angle) * distance;
          const ty = Math.sin(angle) * distance;

          particle.style.setProperty('--tx', tx + 'px');
          particle.style.setProperty('--ty', ty + 'px');
          particle.style.fontSize = (Math.random() * 15 + 18) + 'px';
          particle.style.animationDuration = (Math.random() * 0.5 + 1.5) + 's';

          body.appendChild(particle);
          setTimeout(() => particle.remove(), 1800);
        }
      }

      body.addEventListener('click', createExplosion);
      body.addEventListener('touchstart', createExplosion);

      // Habilitar audio al primer click
      document.addEventListener('click', function() {
        audio.muted = false;
        audio.play().catch(e => console.log("Audio no pudo reproducirse"));
      }, { once: true });
    });
  </script>
</body>
</html>
